package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOfferingStatusRequest(
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest = {
    import GetOfferingStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetOfferingStatusRequest.ReadOnly =
    zio.aws.devicefarm.model.GetOfferingStatusRequest.wrap(buildAwsValue())
}
object GetOfferingStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetOfferingStatusRequest =
      zio.aws.devicefarm.model
        .GetOfferingStatusRequest(nextToken.map(value => value))
    def nextToken: Option[PaginationToken]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest
  ) extends zio.aws.devicefarm.model.GetOfferingStatusRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest
  ): zio.aws.devicefarm.model.GetOfferingStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
