package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, OfferingIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOfferingStatusResponse(
    current: Option[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus]
    ] = None,
    nextPeriod: Option[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse = {
    import GetOfferingStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
      .builder()
      .optionallyWith(
        current.map(value =>
          value
            .map({ case (key, value) =>
              (OfferingIdentifier.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.current)
      .optionallyWith(
        nextPeriod.map(value =>
          value
            .map({ case (key, value) =>
              (OfferingIdentifier.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.nextPeriod)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly =
    zio.aws.devicefarm.model.GetOfferingStatusResponse.wrap(buildAwsValue())
}
object GetOfferingStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetOfferingStatusResponse =
      zio.aws.devicefarm.model.GetOfferingStatusResponse(
        current.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextPeriod.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextToken.map(value => value)
      )
    def current: Option[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ]
    def nextPeriod: Option[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getCurrent: ZIO[Any, AwsError, Map[
      OfferingIdentifier,
      zio.aws.devicefarm.model.OfferingStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("current", current)
    def getNextPeriod: ZIO[Any, AwsError, Map[
      OfferingIdentifier,
      zio.aws.devicefarm.model.OfferingStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("nextPeriod", nextPeriod)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
  ) extends zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly {
    override val current: Option[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ] = scala
      .Option(impl.current())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.devicefarm.model.primitives.OfferingIdentifier(
              key
            ) -> zio.aws.devicefarm.model.OfferingStatus.wrap(value)
          })
          .toMap
      )
    override val nextPeriod: Option[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ] = scala
      .Option(impl.nextPeriod())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.devicefarm.model.primitives.OfferingIdentifier(
              key
            ) -> zio.aws.devicefarm.model.OfferingStatus.wrap(value)
          })
          .toMap
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
  ): zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
