package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRemoteAccessSessionRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest = {
    import GetRemoteAccessSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.GetRemoteAccessSessionRequest.ReadOnly =
    zio.aws.devicefarm.model.GetRemoteAccessSessionRequest.wrap(buildAwsValue())
}
object GetRemoteAccessSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetRemoteAccessSessionRequest =
      zio.aws.devicefarm.model.GetRemoteAccessSessionRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest
  ) extends zio.aws.devicefarm.model.GetRemoteAccessSessionRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest
  ): zio.aws.devicefarm.model.GetRemoteAccessSessionRequest.ReadOnly =
    new Wrapper(impl)
}
