package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRunResponse(
    run: Option[zio.aws.devicefarm.model.Run] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetRunResponse = {
    import GetRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetRunResponse
      .builder()
      .optionallyWith(run.map(value => value.buildAwsValue()))(_.run)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetRunResponse.ReadOnly =
    zio.aws.devicefarm.model.GetRunResponse.wrap(buildAwsValue())
}
object GetRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetRunResponse =
      zio.aws.devicefarm.model
        .GetRunResponse(run.map(value => value.asEditable))
    def run: Option[zio.aws.devicefarm.model.Run.ReadOnly]
    def getRun: ZIO[Any, AwsError, zio.aws.devicefarm.model.Run.ReadOnly] =
      AwsError.unwrapOptionField("run", run)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRunResponse
  ) extends zio.aws.devicefarm.model.GetRunResponse.ReadOnly {
    override val run: Option[zio.aws.devicefarm.model.Run.ReadOnly] = scala
      .Option(impl.run())
      .map(value => zio.aws.devicefarm.model.Run.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRunResponse
  ): zio.aws.devicefarm.model.GetRunResponse.ReadOnly = new Wrapper(impl)
}
