package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSuiteRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest = {
    import GetSuiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetSuiteRequest.ReadOnly =
    zio.aws.devicefarm.model.GetSuiteRequest.wrap(buildAwsValue())
}
object GetSuiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetSuiteRequest =
      zio.aws.devicefarm.model.GetSuiteRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest
  ) extends zio.aws.devicefarm.model.GetSuiteRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest
  ): zio.aws.devicefarm.model.GetSuiteRequest.ReadOnly = new Wrapper(impl)
}
