package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.DeviceFarmArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTestGridProjectRequest(projectArn: DeviceFarmArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest = {
    import GetTestGridProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest
      .builder()
      .projectArn(DeviceFarmArn.unwrap(projectArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetTestGridProjectRequest.ReadOnly =
    zio.aws.devicefarm.model.GetTestGridProjectRequest.wrap(buildAwsValue())
}
object GetTestGridProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetTestGridProjectRequest =
      zio.aws.devicefarm.model.GetTestGridProjectRequest(projectArn)
    def projectArn: DeviceFarmArn
    def getProjectArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest
  ) extends zio.aws.devicefarm.model.GetTestGridProjectRequest.ReadOnly {
    override val projectArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.projectArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest
  ): zio.aws.devicefarm.model.GetTestGridProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
