package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{ResourceId, DeviceFarmArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTestGridSessionRequest(
    projectArn: Option[DeviceFarmArn] = None,
    sessionId: Option[ResourceId] = None,
    sessionArn: Option[DeviceFarmArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest = {
    import GetTestGridSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest
      .builder()
      .optionallyWith(
        projectArn.map(value => DeviceFarmArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        sessionId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        sessionArn.map(value => DeviceFarmArn.unwrap(value): java.lang.String)
      )(_.sessionArn)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetTestGridSessionRequest.ReadOnly =
    zio.aws.devicefarm.model.GetTestGridSessionRequest.wrap(buildAwsValue())
}
object GetTestGridSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetTestGridSessionRequest =
      zio.aws.devicefarm.model.GetTestGridSessionRequest(
        projectArn.map(value => value),
        sessionId.map(value => value),
        sessionArn.map(value => value)
      )
    def projectArn: Option[DeviceFarmArn]
    def sessionId: Option[ResourceId]
    def sessionArn: Option[DeviceFarmArn]
    def getProjectArn: ZIO[Any, AwsError, DeviceFarmArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getSessionId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getSessionArn: ZIO[Any, AwsError, DeviceFarmArn] =
      AwsError.unwrapOptionField("sessionArn", sessionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest
  ) extends zio.aws.devicefarm.model.GetTestGridSessionRequest.ReadOnly {
    override val projectArn: Option[DeviceFarmArn] = scala
      .Option(impl.projectArn())
      .map(value => zio.aws.devicefarm.model.primitives.DeviceFarmArn(value))
    override val sessionId: Option[ResourceId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.devicefarm.model.primitives.ResourceId(value))
    override val sessionArn: Option[DeviceFarmArn] = scala
      .Option(impl.sessionArn())
      .map(value => zio.aws.devicefarm.model.primitives.DeviceFarmArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest
  ): zio.aws.devicefarm.model.GetTestGridSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
