package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTestGridSessionResponse(
    testGridSession: Option[zio.aws.devicefarm.model.TestGridSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionResponse = {
    import GetTestGridSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionResponse
      .builder()
      .optionallyWith(testGridSession.map(value => value.buildAwsValue()))(
        _.testGridSession
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly =
    zio.aws.devicefarm.model.GetTestGridSessionResponse.wrap(buildAwsValue())
}
object GetTestGridSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetTestGridSessionResponse =
      zio.aws.devicefarm.model.GetTestGridSessionResponse(
        testGridSession.map(value => value.asEditable)
      )
    def testGridSession
        : Option[zio.aws.devicefarm.model.TestGridSession.ReadOnly]
    def getTestGridSession: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridSession.ReadOnly
    ] = AwsError.unwrapOptionField("testGridSession", testGridSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionResponse
  ) extends zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly {
    override val testGridSession
        : Option[zio.aws.devicefarm.model.TestGridSession.ReadOnly] = scala
      .Option(impl.testGridSession())
      .map(value => zio.aws.devicefarm.model.TestGridSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionResponse
  ): zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
