package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetVpceConfigurationResponse(
    vpceConfiguration: Option[zio.aws.devicefarm.model.VPCEConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse = {
    import GetVpceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse
      .builder()
      .optionallyWith(vpceConfiguration.map(value => value.buildAwsValue()))(
        _.vpceConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly =
    zio.aws.devicefarm.model.GetVpceConfigurationResponse.wrap(buildAwsValue())
}
object GetVpceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetVpceConfigurationResponse =
      zio.aws.devicefarm.model.GetVpceConfigurationResponse(
        vpceConfiguration.map(value => value.asEditable)
      )
    def vpceConfiguration
        : Option[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly]
    def getVpceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpceConfiguration", vpceConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse
  ) extends zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly {
    override val vpceConfiguration
        : Option[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly] = scala
      .Option(impl.vpceConfiguration())
      .map(value => zio.aws.devicefarm.model.VPCEConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse
  ): zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
