package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InstallToRemoteAccessSessionRequest(
    remoteAccessSessionArn: AmazonResourceName,
    appArn: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest = {
    import InstallToRemoteAccessSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest
      .builder()
      .remoteAccessSessionArn(
        AmazonResourceName.unwrap(remoteAccessSessionArn): java.lang.String
      )
      .appArn(AmazonResourceName.unwrap(appArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest.ReadOnly =
    zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest
      .wrap(buildAwsValue())
}
object InstallToRemoteAccessSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest =
      zio.aws.devicefarm.model
        .InstallToRemoteAccessSessionRequest(remoteAccessSessionArn, appArn)
    def remoteAccessSessionArn: AmazonResourceName
    def appArn: AmazonResourceName
    def getRemoteAccessSessionArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(remoteAccessSessionArn)
    def getAppArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(appArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest
  ) extends zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest.ReadOnly {
    override val remoteAccessSessionArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives
        .AmazonResourceName(impl.remoteAccessSessionArn())
    override val appArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.appArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest
  ): zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest.ReadOnly =
    new Wrapper(impl)
}
