package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstallToRemoteAccessSessionResponse(
    appUpload: Option[zio.aws.devicefarm.model.Upload] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse = {
    import InstallToRemoteAccessSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse
      .builder()
      .optionallyWith(appUpload.map(value => value.buildAwsValue()))(
        _.appUpload
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly =
    zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse
      .wrap(buildAwsValue())
}
object InstallToRemoteAccessSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse =
      zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse(
        appUpload.map(value => value.asEditable)
      )
    def appUpload: Option[zio.aws.devicefarm.model.Upload.ReadOnly]
    def getAppUpload
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Upload.ReadOnly] =
      AwsError.unwrapOptionField("appUpload", appUpload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse
  ) extends zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly {
    override val appUpload: Option[zio.aws.devicefarm.model.Upload.ReadOnly] =
      scala
        .Option(impl.appUpload())
        .map(value => zio.aws.devicefarm.model.Upload.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse
  ): zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly =
    new Wrapper(impl)
}
