package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Message, Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceProfile(
    arn: Option[AmazonResourceName] = None,
    packageCleanup: Option[Boolean] = None,
    excludeAppPackagesFromCleanup: Option[Iterable[String]] = None,
    rebootAfterUse: Option[Boolean] = None,
    name: Option[Name] = None,
    description: Option[Message] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.InstanceProfile = {
    import InstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.InstanceProfile
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(packageCleanup.map(value => value: java.lang.Boolean))(
        _.packageCleanup
      )
      .optionallyWith(
        excludeAppPackagesFromCleanup.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAppPackagesFromCleanup)
      .optionallyWith(rebootAfterUse.map(value => value: java.lang.Boolean))(
        _.rebootAfterUse
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.InstanceProfile.ReadOnly =
    zio.aws.devicefarm.model.InstanceProfile.wrap(buildAwsValue())
}
object InstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.InstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.InstanceProfile =
      zio.aws.devicefarm.model.InstanceProfile(
        arn.map(value => value),
        packageCleanup.map(value => value),
        excludeAppPackagesFromCleanup.map(value => value),
        rebootAfterUse.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def packageCleanup: Option[Boolean]
    def excludeAppPackagesFromCleanup: Option[List[String]]
    def rebootAfterUse: Option[Boolean]
    def name: Option[Name]
    def description: Option[Message]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getPackageCleanup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("packageCleanup", packageCleanup)
    def getExcludeAppPackagesFromCleanup: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "excludeAppPackagesFromCleanup",
        excludeAppPackagesFromCleanup
      )
    def getRebootAfterUse: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rebootAfterUse", rebootAfterUse)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.InstanceProfile
  ) extends zio.aws.devicefarm.model.InstanceProfile.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val packageCleanup: Option[Boolean] =
      scala.Option(impl.packageCleanup()).map(value => value: Boolean)
    override val excludeAppPackagesFromCleanup: Option[List[String]] = scala
      .Option(impl.excludeAppPackagesFromCleanup())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val rebootAfterUse: Option[Boolean] =
      scala.Option(impl.rebootAfterUse()).map(value => value: Boolean)
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Option[Message] = scala
      .Option(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.InstanceProfile
  ): zio.aws.devicefarm.model.InstanceProfile.ReadOnly = new Wrapper(impl)
}
