package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait InteractionMode {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.InteractionMode
}
object InteractionMode {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.InteractionMode
  ): zio.aws.devicefarm.model.InteractionMode = value match {
    case software.amazon.awssdk.services.devicefarm.model.InteractionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.InteractionMode.INTERACTIVE =>
      val r = INTERACTIVE
      r
    case software.amazon.awssdk.services.devicefarm.model.InteractionMode.NO_VIDEO =>
      val r = NO_VIDEO
      r
    case software.amazon.awssdk.services.devicefarm.model.InteractionMode.VIDEO_ONLY =>
      val r = VIDEO_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.InteractionMode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InteractionMode =
      software.amazon.awssdk.services.devicefarm.model.InteractionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERACTIVE extends zio.aws.devicefarm.model.InteractionMode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InteractionMode =
      software.amazon.awssdk.services.devicefarm.model.InteractionMode.INTERACTIVE
  }
  case object NO_VIDEO extends zio.aws.devicefarm.model.InteractionMode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InteractionMode =
      software.amazon.awssdk.services.devicefarm.model.InteractionMode.NO_VIDEO
  }
  case object VIDEO_ONLY extends zio.aws.devicefarm.model.InteractionMode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InteractionMode =
      software.amazon.awssdk.services.devicefarm.model.InteractionMode.VIDEO_ONLY
  }
}
