package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  Message,
  VideoCapture,
  DateTime,
  AmazonResourceName,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Job(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    `type`: Option[zio.aws.devicefarm.model.TestType] = None,
    created: Option[DateTime] = None,
    status: Option[zio.aws.devicefarm.model.ExecutionStatus] = None,
    result: Option[zio.aws.devicefarm.model.ExecutionResult] = None,
    started: Option[DateTime] = None,
    stopped: Option[DateTime] = None,
    counters: Option[zio.aws.devicefarm.model.Counters] = None,
    message: Option[Message] = None,
    device: Option[zio.aws.devicefarm.model.Device] = None,
    instanceArn: Option[AmazonResourceName] = None,
    deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes] = None,
    videoEndpoint: Option[String] = None,
    videoCapture: Option[VideoCapture] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Job
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(stopped.map(value => DateTime.unwrap(value): Instant))(
        _.stopped
      )
      .optionallyWith(counters.map(value => value.buildAwsValue()))(_.counters)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .optionallyWith(
        instanceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.instanceArn)
      .optionallyWith(deviceMinutes.map(value => value.buildAwsValue()))(
        _.deviceMinutes
      )
      .optionallyWith(videoEndpoint.map(value => value: java.lang.String))(
        _.videoEndpoint
      )
      .optionallyWith(
        videoCapture.map(value => VideoCapture.unwrap(value): java.lang.Boolean)
      )(_.videoCapture)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Job.ReadOnly =
    zio.aws.devicefarm.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Job = zio.aws.devicefarm.model.Job(
      arn.map(value => value),
      name.map(value => value),
      `type`.map(value => value),
      created.map(value => value),
      status.map(value => value),
      result.map(value => value),
      started.map(value => value),
      stopped.map(value => value),
      counters.map(value => value.asEditable),
      message.map(value => value),
      device.map(value => value.asEditable),
      instanceArn.map(value => value),
      deviceMinutes.map(value => value.asEditable),
      videoEndpoint.map(value => value),
      videoCapture.map(value => value)
    )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def `type`: Option[zio.aws.devicefarm.model.TestType]
    def created: Option[DateTime]
    def status: Option[zio.aws.devicefarm.model.ExecutionStatus]
    def result: Option[zio.aws.devicefarm.model.ExecutionResult]
    def started: Option[DateTime]
    def stopped: Option[DateTime]
    def counters: Option[zio.aws.devicefarm.model.Counters.ReadOnly]
    def message: Option[Message]
    def device: Option[zio.aws.devicefarm.model.Device.ReadOnly]
    def instanceArn: Option[AmazonResourceName]
    def deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly]
    def videoEndpoint: Option[String]
    def videoCapture: Option[VideoCapture]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.TestType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getStopped: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getCounters
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Counters.ReadOnly] =
      AwsError.unwrapOptionField("counters", counters)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getDevice
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
    def getInstanceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getDeviceMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      AwsError.unwrapOptionField("deviceMinutes", deviceMinutes)
    def getVideoEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("videoEndpoint", videoEndpoint)
    def getVideoCapture: ZIO[Any, AwsError, VideoCapture] =
      AwsError.unwrapOptionField("videoCapture", videoCapture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Job
  ) extends zio.aws.devicefarm.model.Job.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val `type`: Option[zio.aws.devicefarm.model.TestType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.TestType.wrap(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val status: Option[zio.aws.devicefarm.model.ExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.devicefarm.model.ExecutionStatus.wrap(value))
    override val result: Option[zio.aws.devicefarm.model.ExecutionResult] =
      scala
        .Option(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val started: Option[DateTime] = scala
      .Option(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val stopped: Option[DateTime] = scala
      .Option(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val counters: Option[zio.aws.devicefarm.model.Counters.ReadOnly] =
      scala
        .Option(impl.counters())
        .map(value => zio.aws.devicefarm.model.Counters.wrap(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val device: Option[zio.aws.devicefarm.model.Device.ReadOnly] =
      scala
        .Option(impl.device())
        .map(value => zio.aws.devicefarm.model.Device.wrap(value))
    override val instanceArn: Option[AmazonResourceName] = scala
      .Option(impl.instanceArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val deviceMinutes
        : Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] = scala
      .Option(impl.deviceMinutes())
      .map(value => zio.aws.devicefarm.model.DeviceMinutes.wrap(value))
    override val videoEndpoint: Option[String] =
      scala.Option(impl.videoEndpoint()).map(value => value: String)
    override val videoCapture: Option[VideoCapture] = scala
      .Option(impl.videoCapture())
      .map(value => zio.aws.devicefarm.model.primitives.VideoCapture(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Job
  ): zio.aws.devicefarm.model.Job.ReadOnly = new Wrapper(impl)
}
