package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListArtifactsResponse(
    artifacts: Option[Iterable[zio.aws.devicefarm.model.Artifact]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse = {
    import ListArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse
      .builder()
      .optionallyWith(
        artifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifacts)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListArtifactsResponse.wrap(buildAwsValue())
}
object ListArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListArtifactsResponse =
      zio.aws.devicefarm.model.ListArtifactsResponse(
        artifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def artifacts: Option[List[zio.aws.devicefarm.model.Artifact.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getArtifacts
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Artifact.ReadOnly]] =
      AwsError.unwrapOptionField("artifacts", artifacts)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse
  ) extends zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly {
    override val artifacts
        : Option[List[zio.aws.devicefarm.model.Artifact.ReadOnly]] = scala
      .Option(impl.artifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.Artifact.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse
  ): zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly = new Wrapper(impl)
}
