package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDeviceInstancesResponse(
    deviceInstances: Option[Iterable[zio.aws.devicefarm.model.DeviceInstance]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse = {
    import ListDeviceInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
      .builder()
      .optionallyWith(
        deviceInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceInstances)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListDeviceInstancesResponse.wrap(buildAwsValue())
}
object ListDeviceInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListDeviceInstancesResponse =
      zio.aws.devicefarm.model.ListDeviceInstancesResponse(
        deviceInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def deviceInstances
        : Option[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getDeviceInstances: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DeviceInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceInstances", deviceInstances)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
  ) extends zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly {
    override val deviceInstances
        : Option[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]] = scala
      .Option(impl.deviceInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.DeviceInstance.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
  ): zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
