package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDevicePoolsResponse(
    devicePools: Option[Iterable[zio.aws.devicefarm.model.DevicePool]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse = {
    import ListDevicePoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse
      .builder()
      .optionallyWith(
        devicePools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devicePools)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListDevicePoolsResponse.wrap(buildAwsValue())
}
object ListDevicePoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListDevicePoolsResponse =
      zio.aws.devicefarm.model.ListDevicePoolsResponse(
        devicePools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def devicePools: Option[List[zio.aws.devicefarm.model.DevicePool.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getDevicePools: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DevicePool.ReadOnly
    ]] = AwsError.unwrapOptionField("devicePools", devicePools)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse
  ) extends zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly {
    override val devicePools
        : Option[List[zio.aws.devicefarm.model.DevicePool.ReadOnly]] = scala
      .Option(impl.devicePools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.DevicePool.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse
  ): zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly = new Wrapper(
    impl
  )
}
