package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListInstanceProfilesRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest = {
    import ListInstanceProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListInstanceProfilesRequest.ReadOnly =
    zio.aws.devicefarm.model.ListInstanceProfilesRequest.wrap(buildAwsValue())
}
object ListInstanceProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListInstanceProfilesRequest =
      zio.aws.devicefarm.model.ListInstanceProfilesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[Integer]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest
  ) extends zio.aws.devicefarm.model.ListInstanceProfilesRequest.ReadOnly {
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest
  ): zio.aws.devicefarm.model.ListInstanceProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
