package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJobsRequest(
    arn: AmazonResourceName,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListJobsRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListJobsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListJobsRequest =
      zio.aws.devicefarm.model
        .ListJobsRequest(arn, nextToken.map(value => value))
    def arn: AmazonResourceName
    def nextToken: Option[PaginationToken]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListJobsRequest
  ) extends zio.aws.devicefarm.model.ListJobsRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListJobsRequest
  ): zio.aws.devicefarm.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
