package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJobsResponse(
    jobs: Option[Iterable[zio.aws.devicefarm.model.Job]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListJobsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListJobsResponse =
      zio.aws.devicefarm.model.ListJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobs: Option[List[zio.aws.devicefarm.model.Job.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getJobs
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Job.ReadOnly]] =
      AwsError.unwrapOptionField("jobs", jobs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListJobsResponse
  ) extends zio.aws.devicefarm.model.ListJobsResponse.ReadOnly {
    override val jobs: Option[List[zio.aws.devicefarm.model.Job.ReadOnly]] =
      scala
        .Option(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Job.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListJobsResponse
  ): zio.aws.devicefarm.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
