package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNetworkProfilesRequest(
    arn: AmazonResourceName,
    `type`: Option[zio.aws.devicefarm.model.NetworkProfileType] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest = {
    import ListNetworkProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListNetworkProfilesRequest.ReadOnly =
    zio.aws.devicefarm.model.ListNetworkProfilesRequest.wrap(buildAwsValue())
}
object ListNetworkProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListNetworkProfilesRequest =
      zio.aws.devicefarm.model.ListNetworkProfilesRequest(
        arn,
        `type`.map(value => value),
        nextToken.map(value => value)
      )
    def arn: AmazonResourceName
    def `type`: Option[zio.aws.devicefarm.model.NetworkProfileType]
    def nextToken: Option[PaginationToken]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getType
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfileType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest
  ) extends zio.aws.devicefarm.model.ListNetworkProfilesRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val `type`: Option[zio.aws.devicefarm.model.NetworkProfileType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.devicefarm.model.NetworkProfileType.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest
  ): zio.aws.devicefarm.model.ListNetworkProfilesRequest.ReadOnly = new Wrapper(
    impl
  )
}
