package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNetworkProfilesResponse(
    networkProfiles: Option[Iterable[zio.aws.devicefarm.model.NetworkProfile]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse = {
    import ListNetworkProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
      .builder()
      .optionallyWith(
        networkProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkProfiles)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListNetworkProfilesResponse.wrap(buildAwsValue())
}
object ListNetworkProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListNetworkProfilesResponse =
      zio.aws.devicefarm.model.ListNetworkProfilesResponse(
        networkProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkProfiles
        : Option[List[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getNetworkProfiles: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.NetworkProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("networkProfiles", networkProfiles)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
  ) extends zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly {
    override val networkProfiles
        : Option[List[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]] = scala
      .Option(impl.networkProfiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.NetworkProfile.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
  ): zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
