package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOfferingPromotionsResponse(
    offeringPromotions: Option[
      Iterable[zio.aws.devicefarm.model.OfferingPromotion]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse = {
    import ListOfferingPromotionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
      .builder()
      .optionallyWith(
        offeringPromotions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offeringPromotions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListOfferingPromotionsResponse
      .wrap(buildAwsValue())
}
object ListOfferingPromotionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListOfferingPromotionsResponse =
      zio.aws.devicefarm.model.ListOfferingPromotionsResponse(
        offeringPromotions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def offeringPromotions
        : Option[List[zio.aws.devicefarm.model.OfferingPromotion.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getOfferingPromotions: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.OfferingPromotion.ReadOnly
    ]] = AwsError.unwrapOptionField("offeringPromotions", offeringPromotions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
  ) extends zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly {
    override val offeringPromotions
        : Option[List[zio.aws.devicefarm.model.OfferingPromotion.ReadOnly]] =
      scala
        .Option(impl.offeringPromotions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.OfferingPromotion.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
  ): zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly =
    new Wrapper(impl)
}
