package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOfferingTransactionsResponse(
    offeringTransactions: Option[
      Iterable[zio.aws.devicefarm.model.OfferingTransaction]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse = {
    import ListOfferingTransactionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
      .builder()
      .optionallyWith(
        offeringTransactions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offeringTransactions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListOfferingTransactionsResponse
      .wrap(buildAwsValue())
}
object ListOfferingTransactionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListOfferingTransactionsResponse =
      zio.aws.devicefarm.model.ListOfferingTransactionsResponse(
        offeringTransactions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def offeringTransactions
        : Option[List[zio.aws.devicefarm.model.OfferingTransaction.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getOfferingTransactions: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("offeringTransactions", offeringTransactions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
  ) extends zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly {
    override val offeringTransactions
        : Option[List[zio.aws.devicefarm.model.OfferingTransaction.ReadOnly]] =
      scala
        .Option(impl.offeringTransactions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.OfferingTransaction.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
  ): zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly =
    new Wrapper(impl)
}
