package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListProjectsRequest(
    arn: Option[AmazonResourceName] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListProjectsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListProjectsRequest =
      zio.aws.devicefarm.model.ListProjectsRequest(
        arn.map(value => value),
        nextToken.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def nextToken: Option[PaginationToken]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest
  ) extends zio.aws.devicefarm.model.ListProjectsRequest.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest
  ): zio.aws.devicefarm.model.ListProjectsRequest.ReadOnly = new Wrapper(impl)
}
