package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRemoteAccessSessionsRequest(
    arn: AmazonResourceName,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest = {
    import ListRemoteAccessSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest
      .wrap(buildAwsValue())
}
object ListRemoteAccessSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest =
      zio.aws.devicefarm.model
        .ListRemoteAccessSessionsRequest(arn, nextToken.map(value => value))
    def arn: AmazonResourceName
    def nextToken: Option[PaginationToken]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest
  ) extends zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest
  ): zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest.ReadOnly =
    new Wrapper(impl)
}
