package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRemoteAccessSessionsResponse(
    remoteAccessSessions: Option[
      Iterable[zio.aws.devicefarm.model.RemoteAccessSession]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse = {
    import ListRemoteAccessSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse
      .builder()
      .optionallyWith(
        remoteAccessSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remoteAccessSessions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse
      .wrap(buildAwsValue())
}
object ListRemoteAccessSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse =
      zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse(
        remoteAccessSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def remoteAccessSessions
        : Option[List[zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRemoteAccessSessions: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("remoteAccessSessions", remoteAccessSessions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse
  ) extends zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly {
    override val remoteAccessSessions
        : Option[List[zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly]] =
      scala
        .Option(impl.remoteAccessSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.RemoteAccessSession.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse
  ): zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly =
    new Wrapper(impl)
}
