package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRunsResponse(
    runs: Option[Iterable[zio.aws.devicefarm.model.Run]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListRunsResponse = {
    import ListRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListRunsResponse
      .builder()
      .optionallyWith(
        runs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runs)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListRunsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListRunsResponse.wrap(buildAwsValue())
}
object ListRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListRunsResponse =
      zio.aws.devicefarm.model.ListRunsResponse(
        runs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def runs: Option[List[zio.aws.devicefarm.model.Run.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRuns
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Run.ReadOnly]] =
      AwsError.unwrapOptionField("runs", runs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListRunsResponse
  ) extends zio.aws.devicefarm.model.ListRunsResponse.ReadOnly {
    override val runs: Option[List[zio.aws.devicefarm.model.Run.ReadOnly]] =
      scala
        .Option(impl.runs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Run.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListRunsResponse
  ): zio.aws.devicefarm.model.ListRunsResponse.ReadOnly = new Wrapper(impl)
}
