package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSamplesResponse(
    samples: Option[Iterable[zio.aws.devicefarm.model.Sample]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse = {
    import ListSamplesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse
      .builder()
      .optionallyWith(
        samples.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.samples)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListSamplesResponse.wrap(buildAwsValue())
}
object ListSamplesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListSamplesResponse =
      zio.aws.devicefarm.model.ListSamplesResponse(
        samples.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def samples: Option[List[zio.aws.devicefarm.model.Sample.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getSamples
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Sample.ReadOnly]] =
      AwsError.unwrapOptionField("samples", samples)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse
  ) extends zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly {
    override val samples
        : Option[List[zio.aws.devicefarm.model.Sample.ReadOnly]] = scala
      .Option(impl.samples())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.Sample.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse
  ): zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly = new Wrapper(impl)
}
