package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSuitesResponse(
    suites: Option[Iterable[zio.aws.devicefarm.model.Suite]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse = {
    import ListSuitesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
      .builder()
      .optionallyWith(
        suites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suites)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListSuitesResponse.wrap(buildAwsValue())
}
object ListSuitesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListSuitesResponse =
      zio.aws.devicefarm.model.ListSuitesResponse(
        suites.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suites: Option[List[zio.aws.devicefarm.model.Suite.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getSuites
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Suite.ReadOnly]] =
      AwsError.unwrapOptionField("suites", suites)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
  ) extends zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly {
    override val suites: Option[List[zio.aws.devicefarm.model.Suite.ReadOnly]] =
      scala
        .Option(impl.suites())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Suite.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
  ): zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly = new Wrapper(impl)
}
