package zio.aws.devicefarm.model
import java.lang.Integer
import zio.aws.devicefarm.model.primitives.{PaginationToken, MaxPageSize}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTestGridProjectsRequest(
    maxResult: Option[MaxPageSize] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest = {
    import ListTestGridProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest
      .builder()
      .optionallyWith(
        maxResult.map(value => MaxPageSize.unwrap(value): Integer)
      )(_.maxResult)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridProjectsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridProjectsRequest.wrap(buildAwsValue())
}
object ListTestGridProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTestGridProjectsRequest =
      zio.aws.devicefarm.model.ListTestGridProjectsRequest(
        maxResult.map(value => value),
        nextToken.map(value => value)
      )
    def maxResult: Option[MaxPageSize]
    def nextToken: Option[PaginationToken]
    def getMaxResult: ZIO[Any, AwsError, MaxPageSize] =
      AwsError.unwrapOptionField("maxResult", maxResult)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest
  ) extends zio.aws.devicefarm.model.ListTestGridProjectsRequest.ReadOnly {
    override val maxResult: Option[MaxPageSize] = scala
      .Option(impl.maxResult())
      .map(value => zio.aws.devicefarm.model.primitives.MaxPageSize(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest
  ): zio.aws.devicefarm.model.ListTestGridProjectsRequest.ReadOnly =
    new Wrapper(impl)
}
