package zio.aws.devicefarm.model
import java.lang.Integer
import zio.aws.devicefarm.model.primitives.{
  PaginationToken,
  MaxPageSize,
  DeviceFarmArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTestGridSessionActionsRequest(
    sessionArn: DeviceFarmArn,
    maxResult: Option[MaxPageSize] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest = {
    import ListTestGridSessionActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest
      .builder()
      .sessionArn(DeviceFarmArn.unwrap(sessionArn): java.lang.String)
      .optionallyWith(
        maxResult.map(value => MaxPageSize.unwrap(value): Integer)
      )(_.maxResult)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridSessionActionsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridSessionActionsRequest
      .wrap(buildAwsValue())
}
object ListTestGridSessionActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTestGridSessionActionsRequest =
      zio.aws.devicefarm.model.ListTestGridSessionActionsRequest(
        sessionArn,
        maxResult.map(value => value),
        nextToken.map(value => value)
      )
    def sessionArn: DeviceFarmArn
    def maxResult: Option[MaxPageSize]
    def nextToken: Option[PaginationToken]
    def getSessionArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(sessionArn)
    def getMaxResult: ZIO[Any, AwsError, MaxPageSize] =
      AwsError.unwrapOptionField("maxResult", maxResult)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest
  ) extends zio.aws.devicefarm.model.ListTestGridSessionActionsRequest.ReadOnly {
    override val sessionArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.sessionArn())
    override val maxResult: Option[MaxPageSize] = scala
      .Option(impl.maxResult())
      .map(value => zio.aws.devicefarm.model.primitives.MaxPageSize(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest
  ): zio.aws.devicefarm.model.ListTestGridSessionActionsRequest.ReadOnly =
    new Wrapper(impl)
}
