package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTestGridSessionActionsResponse(
    actions: Option[Iterable[zio.aws.devicefarm.model.TestGridSessionAction]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse = {
    import ListTestGridSessionActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse
      .builder()
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridSessionActionsResponse
      .wrap(buildAwsValue())
}
object ListTestGridSessionActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.ListTestGridSessionActionsResponse =
      zio.aws.devicefarm.model.ListTestGridSessionActionsResponse(
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def actions
        : Option[List[zio.aws.devicefarm.model.TestGridSessionAction.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.TestGridSessionAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse
  ) extends zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly {
    override val actions: Option[
      List[zio.aws.devicefarm.model.TestGridSessionAction.ReadOnly]
    ] = scala
      .Option(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.TestGridSessionAction.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse
  ): zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly =
    new Wrapper(impl)
}
