package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTestGridSessionArtifactsResponse(
    artifacts: Option[
      Iterable[zio.aws.devicefarm.model.TestGridSessionArtifact]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse = {
    import ListTestGridSessionArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
      .builder()
      .optionallyWith(
        artifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifacts)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse
      .wrap(buildAwsValue())
}
object ListTestGridSessionArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse =
      zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse(
        artifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def artifacts: Option[
      List[zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getArtifacts: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("artifacts", artifacts)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
  ) extends zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly {
    override val artifacts: Option[
      List[zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly]
    ] = scala
      .Option(impl.artifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.TestGridSessionArtifact.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
  ): zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly =
    new Wrapper(impl)
}
