package zio.aws.devicefarm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  PaginationToken,
  MaxPageSize,
  DateTime,
  DeviceFarmArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTestGridSessionsRequest(
    projectArn: DeviceFarmArn,
    status: Option[zio.aws.devicefarm.model.TestGridSessionStatus] = None,
    creationTimeAfter: Option[DateTime] = None,
    creationTimeBefore: Option[DateTime] = None,
    endTimeAfter: Option[DateTime] = None,
    endTimeBefore: Option[DateTime] = None,
    maxResult: Option[MaxPageSize] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest = {
    import ListTestGridSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest
      .builder()
      .projectArn(DeviceFarmArn.unwrap(projectArn): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTimeAfter.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        endTimeAfter.map(value => DateTime.unwrap(value): Instant)
      )(_.endTimeAfter)
      .optionallyWith(
        endTimeBefore.map(value => DateTime.unwrap(value): Instant)
      )(_.endTimeBefore)
      .optionallyWith(
        maxResult.map(value => MaxPageSize.unwrap(value): Integer)
      )(_.maxResult)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridSessionsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridSessionsRequest.wrap(buildAwsValue())
}
object ListTestGridSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTestGridSessionsRequest =
      zio.aws.devicefarm.model.ListTestGridSessionsRequest(
        projectArn,
        status.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        endTimeAfter.map(value => value),
        endTimeBefore.map(value => value),
        maxResult.map(value => value),
        nextToken.map(value => value)
      )
    def projectArn: DeviceFarmArn
    def status: Option[zio.aws.devicefarm.model.TestGridSessionStatus]
    def creationTimeAfter: Option[DateTime]
    def creationTimeBefore: Option[DateTime]
    def endTimeAfter: Option[DateTime]
    def endTimeBefore: Option[DateTime]
    def maxResult: Option[MaxPageSize]
    def nextToken: Option[PaginationToken]
    def getProjectArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(projectArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.TestGridSessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTimeAfter: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getEndTimeAfter: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTimeAfter", endTimeAfter)
    def getEndTimeBefore: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTimeBefore", endTimeBefore)
    def getMaxResult: ZIO[Any, AwsError, MaxPageSize] =
      AwsError.unwrapOptionField("maxResult", maxResult)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest
  ) extends zio.aws.devicefarm.model.ListTestGridSessionsRequest.ReadOnly {
    override val projectArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.projectArn())
    override val status
        : Option[zio.aws.devicefarm.model.TestGridSessionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devicefarm.model.TestGridSessionStatus.wrap(value))
    override val creationTimeAfter: Option[DateTime] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val creationTimeBefore: Option[DateTime] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val endTimeAfter: Option[DateTime] = scala
      .Option(impl.endTimeAfter())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val endTimeBefore: Option[DateTime] = scala
      .Option(impl.endTimeBefore())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val maxResult: Option[MaxPageSize] = scala
      .Option(impl.maxResult())
      .map(value => zio.aws.devicefarm.model.primitives.MaxPageSize(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest
  ): zio.aws.devicefarm.model.ListTestGridSessionsRequest.ReadOnly =
    new Wrapper(impl)
}
