package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTestsResponse(
    tests: Option[Iterable[zio.aws.devicefarm.model.Test]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestsResponse = {
    import ListTestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
      .builder()
      .optionallyWith(
        tests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tests)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListTestsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListTestsResponse.wrap(buildAwsValue())
}
object ListTestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTestsResponse =
      zio.aws.devicefarm.model.ListTestsResponse(
        tests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tests: Option[List[zio.aws.devicefarm.model.Test.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getTests
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Test.ReadOnly]] =
      AwsError.unwrapOptionField("tests", tests)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
  ) extends zio.aws.devicefarm.model.ListTestsResponse.ReadOnly {
    override val tests: Option[List[zio.aws.devicefarm.model.Test.ReadOnly]] =
      scala
        .Option(impl.tests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Test.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
  ): zio.aws.devicefarm.model.ListTestsResponse.ReadOnly = new Wrapper(impl)
}
