package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListUploadsRequest(
    arn: AmazonResourceName,
    `type`: Option[zio.aws.devicefarm.model.UploadType] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest = {
    import ListUploadsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListUploadsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListUploadsRequest.wrap(buildAwsValue())
}
object ListUploadsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListUploadsRequest =
      zio.aws.devicefarm.model.ListUploadsRequest(
        arn,
        `type`.map(value => value),
        nextToken.map(value => value)
      )
    def arn: AmazonResourceName
    def `type`: Option[zio.aws.devicefarm.model.UploadType]
    def nextToken: Option[PaginationToken]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.UploadType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest
  ) extends zio.aws.devicefarm.model.ListUploadsRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val `type`: Option[zio.aws.devicefarm.model.UploadType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.UploadType.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest
  ): zio.aws.devicefarm.model.ListUploadsRequest.ReadOnly = new Wrapper(impl)
}
