package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListUploadsResponse(
    uploads: Option[Iterable[zio.aws.devicefarm.model.Upload]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse = {
    import ListUploadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse
      .builder()
      .optionallyWith(
        uploads.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploads)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListUploadsResponse.wrap(buildAwsValue())
}
object ListUploadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListUploadsResponse =
      zio.aws.devicefarm.model.ListUploadsResponse(
        uploads.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def uploads: Option[List[zio.aws.devicefarm.model.Upload.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getUploads
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Upload.ReadOnly]] =
      AwsError.unwrapOptionField("uploads", uploads)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse
  ) extends zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly {
    override val uploads
        : Option[List[zio.aws.devicefarm.model.Upload.ReadOnly]] = scala
      .Option(impl.uploads())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.Upload.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse
  ): zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly = new Wrapper(impl)
}
