package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVpceConfigurationsRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest = {
    import ListVpceConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListVpceConfigurationsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListVpceConfigurationsRequest.wrap(buildAwsValue())
}
object ListVpceConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListVpceConfigurationsRequest =
      zio.aws.devicefarm.model.ListVpceConfigurationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[Integer]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest
  ) extends zio.aws.devicefarm.model.ListVpceConfigurationsRequest.ReadOnly {
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest
  ): zio.aws.devicefarm.model.ListVpceConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
