package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVpceConfigurationsResponse(
    vpceConfigurations: Option[
      Iterable[zio.aws.devicefarm.model.VPCEConfiguration]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse = {
    import ListVpceConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
      .builder()
      .optionallyWith(
        vpceConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpceConfigurations)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListVpceConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListVpceConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListVpceConfigurationsResponse =
      zio.aws.devicefarm.model.ListVpceConfigurationsResponse(
        vpceConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpceConfigurations
        : Option[List[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getVpceConfigurations: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("vpceConfigurations", vpceConfigurations)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
  ) extends zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly {
    override val vpceConfigurations
        : Option[List[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly]] =
      scala
        .Option(impl.vpceConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.VPCEConfiguration.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
  ): zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
