package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MonetaryAmount(
    amount: Option[Double] = None,
    currencyCode: Option[zio.aws.devicefarm.model.CurrencyCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.MonetaryAmount = {
    import MonetaryAmount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.Double))(_.amount)
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.MonetaryAmount.ReadOnly =
    zio.aws.devicefarm.model.MonetaryAmount.wrap(buildAwsValue())
}
object MonetaryAmount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.MonetaryAmount =
      zio.aws.devicefarm.model.MonetaryAmount(
        amount.map(value => value),
        currencyCode.map(value => value)
      )
    def amount: Option[Double]
    def currencyCode: Option[zio.aws.devicefarm.model.CurrencyCode]
    def getAmount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("amount", amount)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.CurrencyCode] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
  ) extends zio.aws.devicefarm.model.MonetaryAmount.ReadOnly {
    override val amount: Option[Double] =
      scala.Option(impl.amount()).map(value => value: Double)
    override val currencyCode: Option[zio.aws.devicefarm.model.CurrencyCode] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.devicefarm.model.CurrencyCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
  ): zio.aws.devicefarm.model.MonetaryAmount.ReadOnly = new Wrapper(impl)
}
