package zio.aws.devicefarm.model
import java.lang.Integer
import zio.aws.devicefarm.model.primitives.{
  PercentInteger,
  Message,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkProfile(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    description: Option[Message] = None,
    `type`: Option[zio.aws.devicefarm.model.NetworkProfileType] = None,
    uplinkBandwidthBits: Option[Long] = None,
    downlinkBandwidthBits: Option[Long] = None,
    uplinkDelayMs: Option[Long] = None,
    downlinkDelayMs: Option[Long] = None,
    uplinkJitterMs: Option[Long] = None,
    downlinkJitterMs: Option[Long] = None,
    uplinkLossPercent: Option[PercentInteger] = None,
    downlinkLossPercent: Option[PercentInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.NetworkProfile = {
    import NetworkProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.NetworkProfile
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(uplinkBandwidthBits.map(value => value: java.lang.Long))(
        _.uplinkBandwidthBits
      )
      .optionallyWith(
        downlinkBandwidthBits.map(value => value: java.lang.Long)
      )(_.downlinkBandwidthBits)
      .optionallyWith(uplinkDelayMs.map(value => value: java.lang.Long))(
        _.uplinkDelayMs
      )
      .optionallyWith(downlinkDelayMs.map(value => value: java.lang.Long))(
        _.downlinkDelayMs
      )
      .optionallyWith(uplinkJitterMs.map(value => value: java.lang.Long))(
        _.uplinkJitterMs
      )
      .optionallyWith(downlinkJitterMs.map(value => value: java.lang.Long))(
        _.downlinkJitterMs
      )
      .optionallyWith(
        uplinkLossPercent.map(value => PercentInteger.unwrap(value): Integer)
      )(_.uplinkLossPercent)
      .optionallyWith(
        downlinkLossPercent.map(value => PercentInteger.unwrap(value): Integer)
      )(_.downlinkLossPercent)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.NetworkProfile.ReadOnly =
    zio.aws.devicefarm.model.NetworkProfile.wrap(buildAwsValue())
}
object NetworkProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.NetworkProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.NetworkProfile =
      zio.aws.devicefarm.model.NetworkProfile(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        uplinkBandwidthBits.map(value => value),
        downlinkBandwidthBits.map(value => value),
        uplinkDelayMs.map(value => value),
        downlinkDelayMs.map(value => value),
        uplinkJitterMs.map(value => value),
        downlinkJitterMs.map(value => value),
        uplinkLossPercent.map(value => value),
        downlinkLossPercent.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def description: Option[Message]
    def `type`: Option[zio.aws.devicefarm.model.NetworkProfileType]
    def uplinkBandwidthBits: Option[Long]
    def downlinkBandwidthBits: Option[Long]
    def uplinkDelayMs: Option[Long]
    def downlinkDelayMs: Option[Long]
    def uplinkJitterMs: Option[Long]
    def downlinkJitterMs: Option[Long]
    def uplinkLossPercent: Option[PercentInteger]
    def downlinkLossPercent: Option[PercentInteger]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getType
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfileType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUplinkBandwidthBits: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkBandwidthBits", uplinkBandwidthBits)
    def getDownlinkBandwidthBits: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkBandwidthBits", downlinkBandwidthBits)
    def getUplinkDelayMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkDelayMs", uplinkDelayMs)
    def getDownlinkDelayMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkDelayMs", downlinkDelayMs)
    def getUplinkJitterMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkJitterMs", uplinkJitterMs)
    def getDownlinkJitterMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkJitterMs", downlinkJitterMs)
    def getUplinkLossPercent: ZIO[Any, AwsError, PercentInteger] =
      AwsError.unwrapOptionField("uplinkLossPercent", uplinkLossPercent)
    def getDownlinkLossPercent: ZIO[Any, AwsError, PercentInteger] =
      AwsError.unwrapOptionField("downlinkLossPercent", downlinkLossPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.NetworkProfile
  ) extends zio.aws.devicefarm.model.NetworkProfile.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Option[Message] = scala
      .Option(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val `type`: Option[zio.aws.devicefarm.model.NetworkProfileType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.devicefarm.model.NetworkProfileType.wrap(value))
    override val uplinkBandwidthBits: Option[Long] =
      scala.Option(impl.uplinkBandwidthBits()).map(value => value: Long)
    override val downlinkBandwidthBits: Option[Long] =
      scala.Option(impl.downlinkBandwidthBits()).map(value => value: Long)
    override val uplinkDelayMs: Option[Long] =
      scala.Option(impl.uplinkDelayMs()).map(value => value: Long)
    override val downlinkDelayMs: Option[Long] =
      scala.Option(impl.downlinkDelayMs()).map(value => value: Long)
    override val uplinkJitterMs: Option[Long] =
      scala.Option(impl.uplinkJitterMs()).map(value => value: Long)
    override val downlinkJitterMs: Option[Long] =
      scala.Option(impl.downlinkJitterMs()).map(value => value: Long)
    override val uplinkLossPercent: Option[PercentInteger] = scala
      .Option(impl.uplinkLossPercent())
      .map(value => zio.aws.devicefarm.model.primitives.PercentInteger(value))
    override val downlinkLossPercent: Option[PercentInteger] = scala
      .Option(impl.downlinkLossPercent())
      .map(value => zio.aws.devicefarm.model.primitives.PercentInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.NetworkProfile
  ): zio.aws.devicefarm.model.NetworkProfile.ReadOnly = new Wrapper(impl)
}
