package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Message, OfferingIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Offering(
    id: Option[OfferingIdentifier] = None,
    description: Option[Message] = None,
    `type`: Option[zio.aws.devicefarm.model.OfferingType] = None,
    platform: Option[zio.aws.devicefarm.model.DevicePlatform] = None,
    recurringCharges: Option[
      Iterable[zio.aws.devicefarm.model.RecurringCharge]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Offering = {
    import Offering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Offering
      .builder()
      .optionallyWith(
        id.map(value => OfferingIdentifier.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Offering.ReadOnly =
    zio.aws.devicefarm.model.Offering.wrap(buildAwsValue())
}
object Offering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Offering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Offering =
      zio.aws.devicefarm.model.Offering(
        id.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        platform.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Option[OfferingIdentifier]
    def description: Option[Message]
    def `type`: Option[zio.aws.devicefarm.model.OfferingType]
    def platform: Option[zio.aws.devicefarm.model.DevicePlatform]
    def recurringCharges
        : Option[List[zio.aws.devicefarm.model.RecurringCharge.ReadOnly]]
    def getId: ZIO[Any, AwsError, OfferingIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.OfferingType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Offering
  ) extends zio.aws.devicefarm.model.Offering.ReadOnly {
    override val id: Option[OfferingIdentifier] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.devicefarm.model.primitives.OfferingIdentifier(value)
      )
    override val description: Option[Message] = scala
      .Option(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val `type`: Option[zio.aws.devicefarm.model.OfferingType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.OfferingType.wrap(value))
    override val platform: Option[zio.aws.devicefarm.model.DevicePlatform] =
      scala
        .Option(impl.platform())
        .map(value => zio.aws.devicefarm.model.DevicePlatform.wrap(value))
    override val recurringCharges
        : Option[List[zio.aws.devicefarm.model.RecurringCharge.ReadOnly]] =
      scala
        .Option(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Offering
  ): zio.aws.devicefarm.model.Offering.ReadOnly = new Wrapper(impl)
}
