package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OfferingStatus(
    `type`: Option[zio.aws.devicefarm.model.OfferingTransactionType] = None,
    offering: Option[zio.aws.devicefarm.model.Offering] = None,
    quantity: Option[Integer] = None,
    effectiveOn: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.OfferingStatus = {
    import OfferingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.OfferingStatus
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(offering.map(value => value.buildAwsValue()))(_.offering)
      .optionallyWith(
        quantity.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.quantity)
      .optionallyWith(
        effectiveOn.map(value => DateTime.unwrap(value): Instant)
      )(_.effectiveOn)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.OfferingStatus.ReadOnly =
    zio.aws.devicefarm.model.OfferingStatus.wrap(buildAwsValue())
}
object OfferingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.OfferingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.OfferingStatus =
      zio.aws.devicefarm.model.OfferingStatus(
        `type`.map(value => value),
        offering.map(value => value.asEditable),
        quantity.map(value => value),
        effectiveOn.map(value => value)
      )
    def `type`: Option[zio.aws.devicefarm.model.OfferingTransactionType]
    def offering: Option[zio.aws.devicefarm.model.Offering.ReadOnly]
    def quantity: Option[Integer]
    def effectiveOn: Option[DateTime]
    def getType
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.OfferingTransactionType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOffering
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Offering.ReadOnly] =
      AwsError.unwrapOptionField("offering", offering)
    def getQuantity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("quantity", quantity)
    def getEffectiveOn: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("effectiveOn", effectiveOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingStatus
  ) extends zio.aws.devicefarm.model.OfferingStatus.ReadOnly {
    override val `type`
        : Option[zio.aws.devicefarm.model.OfferingTransactionType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.devicefarm.model.OfferingTransactionType.wrap(value)
      )
    override val offering: Option[zio.aws.devicefarm.model.Offering.ReadOnly] =
      scala
        .Option(impl.offering())
        .map(value => zio.aws.devicefarm.model.Offering.wrap(value))
    override val quantity: Option[Integer] = scala
      .Option(impl.quantity())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val effectiveOn: Option[DateTime] = scala
      .Option(impl.effectiveOn())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingStatus
  ): zio.aws.devicefarm.model.OfferingStatus.ReadOnly = new Wrapper(impl)
}
