package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  DateTime,
  OfferingPromotionIdentifier,
  TransactionIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OfferingTransaction(
    offeringStatus: Option[zio.aws.devicefarm.model.OfferingStatus] = None,
    transactionId: Option[TransactionIdentifier] = None,
    offeringPromotionId: Option[OfferingPromotionIdentifier] = None,
    createdOn: Option[DateTime] = None,
    cost: Option[zio.aws.devicefarm.model.MonetaryAmount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.OfferingTransaction = {
    import OfferingTransaction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
      .builder()
      .optionallyWith(offeringStatus.map(value => value.buildAwsValue()))(
        _.offeringStatus
      )
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdentifier.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .optionallyWith(
        offeringPromotionId.map(value =>
          OfferingPromotionIdentifier.unwrap(value): java.lang.String
        )
      )(_.offeringPromotionId)
      .optionallyWith(createdOn.map(value => DateTime.unwrap(value): Instant))(
        _.createdOn
      )
      .optionallyWith(cost.map(value => value.buildAwsValue()))(_.cost)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.OfferingTransaction.ReadOnly =
    zio.aws.devicefarm.model.OfferingTransaction.wrap(buildAwsValue())
}
object OfferingTransaction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.OfferingTransaction =
      zio.aws.devicefarm.model.OfferingTransaction(
        offeringStatus.map(value => value.asEditable),
        transactionId.map(value => value),
        offeringPromotionId.map(value => value),
        createdOn.map(value => value),
        cost.map(value => value.asEditable)
      )
    def offeringStatus: Option[zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    def transactionId: Option[TransactionIdentifier]
    def offeringPromotionId: Option[OfferingPromotionIdentifier]
    def createdOn: Option[DateTime]
    def cost: Option[zio.aws.devicefarm.model.MonetaryAmount.ReadOnly]
    def getOfferingStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.OfferingStatus.ReadOnly] =
      AwsError.unwrapOptionField("offeringStatus", offeringStatus)
    def getTransactionId: ZIO[Any, AwsError, TransactionIdentifier] =
      AwsError.unwrapOptionField("transactionId", transactionId)
    def getOfferingPromotionId
        : ZIO[Any, AwsError, OfferingPromotionIdentifier] =
      AwsError.unwrapOptionField("offeringPromotionId", offeringPromotionId)
    def getCreatedOn: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdOn", createdOn)
    def getCost
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.MonetaryAmount.ReadOnly] =
      AwsError.unwrapOptionField("cost", cost)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
  ) extends zio.aws.devicefarm.model.OfferingTransaction.ReadOnly {
    override val offeringStatus
        : Option[zio.aws.devicefarm.model.OfferingStatus.ReadOnly] = scala
      .Option(impl.offeringStatus())
      .map(value => zio.aws.devicefarm.model.OfferingStatus.wrap(value))
    override val transactionId: Option[TransactionIdentifier] = scala
      .Option(impl.transactionId())
      .map(value =>
        zio.aws.devicefarm.model.primitives.TransactionIdentifier(value)
      )
    override val offeringPromotionId: Option[OfferingPromotionIdentifier] =
      scala
        .Option(impl.offeringPromotionId())
        .map(value =>
          zio.aws.devicefarm.model.primitives.OfferingPromotionIdentifier(value)
        )
    override val createdOn: Option[DateTime] = scala
      .Option(impl.createdOn())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val cost
        : Option[zio.aws.devicefarm.model.MonetaryAmount.ReadOnly] = scala
      .Option(impl.cost())
      .map(value => zio.aws.devicefarm.model.MonetaryAmount.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
  ): zio.aws.devicefarm.model.OfferingTransaction.ReadOnly = new Wrapper(impl)
}
