package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait OfferingType {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.OfferingType
}
object OfferingType {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.OfferingType
  ): zio.aws.devicefarm.model.OfferingType = value match {
    case software.amazon.awssdk.services.devicefarm.model.OfferingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.OfferingType.RECURRING =>
      val r = RECURRING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.OfferingType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.OfferingType =
      software.amazon.awssdk.services.devicefarm.model.OfferingType.UNKNOWN_TO_SDK_VERSION
  }
  case object RECURRING extends zio.aws.devicefarm.model.OfferingType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.OfferingType =
      software.amazon.awssdk.services.devicefarm.model.OfferingType.RECURRING
  }
}
