package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Message
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Problem(
    run: Option[zio.aws.devicefarm.model.ProblemDetail] = None,
    job: Option[zio.aws.devicefarm.model.ProblemDetail] = None,
    suite: Option[zio.aws.devicefarm.model.ProblemDetail] = None,
    test: Option[zio.aws.devicefarm.model.ProblemDetail] = None,
    device: Option[zio.aws.devicefarm.model.Device] = None,
    result: Option[zio.aws.devicefarm.model.ExecutionResult] = None,
    message: Option[Message] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Problem = {
    import Problem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Problem
      .builder()
      .optionallyWith(run.map(value => value.buildAwsValue()))(_.run)
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .optionallyWith(suite.map(value => value.buildAwsValue()))(_.suite)
      .optionallyWith(test.map(value => value.buildAwsValue()))(_.test)
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Problem.ReadOnly =
    zio.aws.devicefarm.model.Problem.wrap(buildAwsValue())
}
object Problem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Problem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Problem =
      zio.aws.devicefarm.model.Problem(
        run.map(value => value.asEditable),
        job.map(value => value.asEditable),
        suite.map(value => value.asEditable),
        test.map(value => value.asEditable),
        device.map(value => value.asEditable),
        result.map(value => value),
        message.map(value => value)
      )
    def run: Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def job: Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def suite: Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def test: Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def device: Option[zio.aws.devicefarm.model.Device.ReadOnly]
    def result: Option[zio.aws.devicefarm.model.ExecutionResult]
    def message: Option[Message]
    def getRun
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("run", run)
    def getJob
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
    def getSuite
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("suite", suite)
    def getTest
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("test", test)
    def getDevice
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Problem
  ) extends zio.aws.devicefarm.model.Problem.ReadOnly {
    override val run: Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      scala
        .Option(impl.run())
        .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val job: Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      scala
        .Option(impl.job())
        .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val suite
        : Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] = scala
      .Option(impl.suite())
      .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val test: Option[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      scala
        .Option(impl.test())
        .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val device: Option[zio.aws.devicefarm.model.Device.ReadOnly] =
      scala
        .Option(impl.device())
        .map(value => zio.aws.devicefarm.model.Device.wrap(value))
    override val result: Option[zio.aws.devicefarm.model.ExecutionResult] =
      scala
        .Option(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Problem
  ): zio.aws.devicefarm.model.Problem.ReadOnly = new Wrapper(impl)
}
