package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  OfferingPromotionIdentifier,
  Integer,
  OfferingIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PurchaseOfferingRequest(
    offeringId: OfferingIdentifier,
    quantity: Integer,
    offeringPromotionId: Option[OfferingPromotionIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest = {
    import PurchaseOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest
      .builder()
      .offeringId(OfferingIdentifier.unwrap(offeringId): java.lang.String)
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        offeringPromotionId.map(value =>
          OfferingPromotionIdentifier.unwrap(value): java.lang.String
        )
      )(_.offeringPromotionId)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.PurchaseOfferingRequest.ReadOnly =
    zio.aws.devicefarm.model.PurchaseOfferingRequest.wrap(buildAwsValue())
}
object PurchaseOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.PurchaseOfferingRequest =
      zio.aws.devicefarm.model.PurchaseOfferingRequest(
        offeringId,
        quantity,
        offeringPromotionId.map(value => value)
      )
    def offeringId: OfferingIdentifier
    def quantity: Integer
    def offeringPromotionId: Option[OfferingPromotionIdentifier]
    def getOfferingId: ZIO[Any, Nothing, OfferingIdentifier] =
      ZIO.succeed(offeringId)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getOfferingPromotionId
        : ZIO[Any, AwsError, OfferingPromotionIdentifier] =
      AwsError.unwrapOptionField("offeringPromotionId", offeringPromotionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest
  ) extends zio.aws.devicefarm.model.PurchaseOfferingRequest.ReadOnly {
    override val offeringId: OfferingIdentifier =
      zio.aws.devicefarm.model.primitives.OfferingIdentifier(impl.offeringId())
    override val quantity: Integer =
      zio.aws.devicefarm.model.primitives.Integer(impl.quantity())
    override val offeringPromotionId: Option[OfferingPromotionIdentifier] =
      scala
        .Option(impl.offeringPromotionId())
        .map(value =>
          zio.aws.devicefarm.model.primitives.OfferingPromotionIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest
  ): zio.aws.devicefarm.model.PurchaseOfferingRequest.ReadOnly = new Wrapper(
    impl
  )
}
