package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Radios(
    wifi: Option[Boolean] = None,
    bluetooth: Option[Boolean] = None,
    nfc: Option[Boolean] = None,
    gps: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Radios = {
    import Radios.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Radios
      .builder()
      .optionallyWith(wifi.map(value => value: java.lang.Boolean))(_.wifi)
      .optionallyWith(bluetooth.map(value => value: java.lang.Boolean))(
        _.bluetooth
      )
      .optionallyWith(nfc.map(value => value: java.lang.Boolean))(_.nfc)
      .optionallyWith(gps.map(value => value: java.lang.Boolean))(_.gps)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Radios.ReadOnly =
    zio.aws.devicefarm.model.Radios.wrap(buildAwsValue())
}
object Radios {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Radios] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Radios =
      zio.aws.devicefarm.model.Radios(
        wifi.map(value => value),
        bluetooth.map(value => value),
        nfc.map(value => value),
        gps.map(value => value)
      )
    def wifi: Option[Boolean]
    def bluetooth: Option[Boolean]
    def nfc: Option[Boolean]
    def gps: Option[Boolean]
    def getWifi: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("wifi", wifi)
    def getBluetooth: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("bluetooth", bluetooth)
    def getNfc: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("nfc", nfc)
    def getGps: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("gps", gps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Radios
  ) extends zio.aws.devicefarm.model.Radios.ReadOnly {
    override val wifi: Option[Boolean] =
      scala.Option(impl.wifi()).map(value => value: Boolean)
    override val bluetooth: Option[Boolean] =
      scala.Option(impl.bluetooth()).map(value => value: Boolean)
    override val nfc: Option[Boolean] =
      scala.Option(impl.nfc()).map(value => value: Boolean)
    override val gps: Option[Boolean] =
      scala.Option(impl.gps()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Radios
  ): zio.aws.devicefarm.model.Radios.ReadOnly = new Wrapper(impl)
}
