package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecurringCharge(
    cost: Option[zio.aws.devicefarm.model.MonetaryAmount] = None,
    frequency: Option[zio.aws.devicefarm.model.RecurringChargeFrequency] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.RecurringCharge = {
    import RecurringCharge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.RecurringCharge
      .builder()
      .optionallyWith(cost.map(value => value.buildAwsValue()))(_.cost)
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.RecurringCharge.ReadOnly =
    zio.aws.devicefarm.model.RecurringCharge.wrap(buildAwsValue())
}
object RecurringCharge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.RecurringCharge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.RecurringCharge =
      zio.aws.devicefarm.model.RecurringCharge(
        cost.map(value => value.asEditable),
        frequency.map(value => value)
      )
    def cost: Option[zio.aws.devicefarm.model.MonetaryAmount.ReadOnly]
    def frequency: Option[zio.aws.devicefarm.model.RecurringChargeFrequency]
    def getCost
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.MonetaryAmount.ReadOnly] =
      AwsError.unwrapOptionField("cost", cost)
    def getFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.RecurringChargeFrequency
    ] = AwsError.unwrapOptionField("frequency", frequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.RecurringCharge
  ) extends zio.aws.devicefarm.model.RecurringCharge.ReadOnly {
    override val cost
        : Option[zio.aws.devicefarm.model.MonetaryAmount.ReadOnly] = scala
      .Option(impl.cost())
      .map(value => zio.aws.devicefarm.model.MonetaryAmount.wrap(value))
    override val frequency
        : Option[zio.aws.devicefarm.model.RecurringChargeFrequency] = scala
      .Option(impl.frequency())
      .map(value =>
        zio.aws.devicefarm.model.RecurringChargeFrequency.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.RecurringCharge
  ): zio.aws.devicefarm.model.RecurringCharge.ReadOnly = new Wrapper(impl)
}
